/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.postprocessing;

import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.FlowValue;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.postprocessing.FlowPostProcessor;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.postprocessing.InstantiationInfo;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.postprocessing.StringConcatInfo;
import club.sk1er.mods.scrollabletooltips.mixinextras.lib.apache.commons.tuple.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public class StringConcatPostProcessor
implements FlowPostProcessor {
    private static final String STRING_BUILDER = Type.getInternalName(StringBuilder.class);

    @Override
    public void process(FlowValue node2, FlowPostProcessor.OutputSink sink) {
        Pair<FlowValue, Integer> child;
        FlowValue firstAppend = this.getFirstAppend(node2);
        if (firstAppend == null) {
            return;
        }
        ArrayList<FlowValue> appendCalls = new ArrayList<FlowValue>();
        FlowValue currentAppend = firstAppend;
        while (true) {
            appendCalls.add(currentAppend);
            Collection<Pair<FlowValue, Integer>> next = currentAppend.getNext();
            if (next.size() != 1) {
                return;
            }
            child = next.iterator().next();
            if (!this.isAppendCall(child)) break;
            currentAppend = child.getLeft();
        }
        if (!this.isToStringCall(child)) {
            return;
        }
        FlowValue toStringCall = child.getLeft();
        if (appendCalls.size() < 2) {
            return;
        }
        StringConcatPostProcessor.decorateConcat(appendCalls, toStringCall);
    }

    public static void decorateConcat(List<FlowValue> appendCalls, FlowValue toStringCall) {
        FlowValue initialComponent = appendCalls.get(0).getInput(1);
        for (int i2 = 1; i2 < appendCalls.size() - 1; ++i2) {
            appendCalls.get(i2).decorate("stringConcatInfo", new StringConcatInfo(i2 == 1, false, initialComponent, toStringCall));
        }
        toStringCall.decorate("stringConcatInfo", new StringConcatInfo(appendCalls.size() == 2, true, initialComponent, toStringCall));
    }

    private FlowValue getFirstAppend(FlowValue node2) {
        InstantiationInfo instantiation = (InstantiationInfo)node2.getDecoration("instantiationInfo");
        if (instantiation == null || !instantiation.type.getInternalName().equals(STRING_BUILDER)) {
            return null;
        }
        if (!this.isEmptyInit(instantiation.initCall)) {
            return null;
        }
        if (node2.getNext().size() != 1) {
            return null;
        }
        Pair<FlowValue, Integer> firstAppend = node2.getNext().iterator().next();
        if (this.isAppendCall(firstAppend)) {
            return firstAppend.getLeft();
        }
        return null;
    }

    private boolean isEmptyInit(FlowValue call) {
        return ((MethodInsnNode)call.getInsn()).desc.equals("()V");
    }

    private boolean isAppendCall(Pair<FlowValue, Integer> child) {
        if (child.getRight() != 0) {
            return false;
        }
        AbstractInsnNode insn = child.getLeft().getInsn();
        if (insn.getOpcode() != 182) {
            return false;
        }
        MethodInsnNode call = (MethodInsnNode)insn;
        return call.owner.equals(STRING_BUILDER) && call.name.equals("append") && Type.getArgumentTypes((String)call.desc).length == 1;
    }

    private boolean isToStringCall(Pair<FlowValue, Integer> child) {
        if (child.getRight() != 0) {
            return false;
        }
        AbstractInsnNode insn = child.getLeft().getInsn();
        if (insn.getOpcode() != 182) {
            return false;
        }
        MethodInsnNode call = (MethodInsnNode)insn;
        return call.owner.equals(STRING_BUILDER) && call.name.equals("toString");
    }
}

